<?php
if (!empty($_SERVER['SCRIPT_FILENAME']) && 'comments.php' == basename($_SERVER['SCRIPT_FILENAME'])) die ('Please do not load this page directly. Thanks!');
if ( post_password_required() ) { ?>
        <p class="nocomments">This post is password protected. Enter the password to view comments.</p>
<?php
  return;
}
?>
<?php if ( have_comments() ) : ?>
        <h4 id="comments"><?php comments_number('No Responses', 'One Response', '% Responses' );?> to &#8220;<?php the_title(); ?>&#8221;</h4>
        <ol class="commentlist">
          <?php wp_list_comments('avatar_size=68&max_depth=8&per_page=100&callback='); ?>
        </ol>
        <ul class="lead comment-nav">
          <li class="prev"><?php next_comments_link('Previous comments') ?></li>
          <li class="next"><?php previous_comments_link('Next comments') ?></li>
        </ul>
 <?php else : // this is displayed if there are no comments so far ?>
  <?php if ('open' == $post->comment_status) : ?>
    <!-- If comments are open, but there are no comments. -->
   <?php else : // comments are closed ?>
    <!-- If comments are closed. -->
        <p class="nocomments">Comments are closed.</p>
  <?php endif; ?>
<?php endif; ?>

<?php if ('open' == $post->comment_status) : ?>
        <div id="respond">
          <h4><?php comment_form_title( 'Leave a comment', 'Leave a comment to %s' );?></h4>
          <div class="cancel-comment-reply"><?php cancel_comment_reply_link(); ?></div>
<?php if ( get_option('comment_registration') && !$user_ID ) : ?>
          <p>You must be <a href="<?php echo get_option('siteurl'); ?>/wp-login.php?redirect_to=<?php the_permalink(); ?>">logged in</a> to post a comment.</p>
<?php else : ?>
          <form action="<?php echo get_option('siteurl'); ?>/wp-comments-post.php" method="post" id="commentform">
            <div>
<?php if ( $user_ID ) : ?>
              <p>Logged in as <a href="<?php echo get_option('siteurl'); ?>/wp-admin/profile.php"><?php echo $user_identity; ?></a>. <a href="<?php echo get_option('siteurl'); ?>/wp-login.php?loggedout=true" title="Log out of this account">Logout &raquo;</a></p>
<?php else : ?>
              <div class="inputs">
                <input type="text" alt="Your Name" name="author" class="form-input" id="author" value="<?php if($comment_author) echo $comment_author; else echo 'Your Name'; ?><?php if ($req && !$comment_author) echo ' (required)'; ?>" />
                <input type="text" alt="Your Email" name="email" class="form-input" id="email" value="<?php if($comment_author_email) echo $comment_author_email; else echo 'Your Email'; ?><?php if ($req && !$comment_author) echo ' (required)'; ?>" />
                <input type="text" alt="Your Website" name="url" class="form-input" id="url" value="<?php if($comment_author_url) echo $comment_author_url; else echo 'Your Website'; ?>" />
              </div>
<?php endif; ?>
              <textarea name="comment" alt="Your Message" class="form-textarea<?php if ($user_ID) echo ' comment-text'; ?>" id="comment" cols="50" rows="5"><?php if (!$user_ID) echo 'Your Message'; ?></textarea>
              <div class="extra"></div>
              <input name="submit" alt="Submit Comment" type="submit" class="form-submit" id="submit" value="Submit Comment" />
              <?php comment_id_fields(); ?>
            </div>
<?php do_action('comment_form', $post->ID); ?>

          </form>
<?php endif; // If registration required and not logged in ?>
        </div>
<?php endif; // if you delete this the sky will fall on your head ?>
          <!-- #comment-box -->
